/** @file   datatypes.h
 * @brief   Defines the general datatypes we use in the game.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#include "objectmessage.h"

namespace WeWantWar {



/** Indicates the type of the object that is located at the pointer. For
 * instance methods that can use both normal bitmaps and rle-sprites need
 * this information.
 */
enum {
  /** Indicates normal BITMAP. Color 0/(bright ping) should not be
   * considered as transparent.
   */
  SPTYPE_BITMAP,
  /** Indicates that we should draw the bitmap as a sprite. */
  SPTYPE_SPRITE,
  /** Indicates that we should consider the object at the pointer as
   * rle-sprite
   */
  SPTYPE_RLE
};


/** Defines a type for Opacity values. */
typedef int OpacityVal;



/** An object message that instructs the Object to change its target */
const ObjectMessage::MessageID OBJMESS_TARGETCHANGE = 1;
/** An id of message that has no general meaning. */
const ObjectMessage::MessageID OBJMESS_DEFAULT = 2;
/** An id of response message. */
const ObjectMessage::MessageID OBJMESS_RESPONSE = 3;
/** An id of message that asks the GameObject to change the state of it's
 * controller object.
 */
const ObjectMessage::MessageID OBJMESS_CONTROLLER_MODE = 4;
/** An id of message that requests the GameObject to change the weapon.
 */
const ObjectMessage::MessageID OBJMESS_WEAPON_CHANGE = 5;


};  // end of namespace
